/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.compatibility.jei.transfer;

import com.minecolonies.api.colony.buildings.modules.ICraftingBuildingModule;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.coremod.colony.buildings.moduleviews.CraftingModuleView;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingWorkerView;
import com.minecolonies.coremod.compatibility.jei.GenericRecipeCategory;
import com.minecolonies.coremod.compatibility.jei.JobBasedRecipeCategory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTeachingGuiHandler<W extends ContainerScreen<?>>
implements IGuiContainerHandler<W>,
IGhostIngredientHandler<W> {
    @NotNull
    private final Map<ResourceLocation, GenericRecipeCategory> categories;

    protected AbstractTeachingGuiHandler(@NotNull List<GenericRecipeCategory> categories) {
        this.categories = categories.stream().collect(Collectors.toMap(JobBasedRecipeCategory::getUid, Function.identity()));
    }

    public void register(@NotNull IGuiHandlerRegistration registration) {
        registration.addGuiContainerHandler(this.getWindowClass(), (IGuiContainerHandler)this);
        registration.addGhostIngredientHandler(this.getWindowClass(), (IGhostIngredientHandler)this);
    }

    @NotNull
    protected abstract Class<W> getWindowClass();

    protected abstract boolean isSupportedCraftingModule(@NotNull CraftingModuleView var1);

    protected abstract boolean isSupportedSlot(@NotNull Slot var1);

    protected abstract void updateServer(@NotNull W var1);

    @Nullable
    protected GenericRecipeCategory getRecipeCategory(@NotNull AbstractBuildingWorkerView view) {
        for (CraftingModuleView moduleView : view.getModuleViews(CraftingModuleView.class)) {
            ResourceLocation uid;
            GenericRecipeCategory category;
            JobEntry jobEntry;
            if (!this.isSupportedCraftingModule(moduleView) || (jobEntry = moduleView.getJobEntry()) == null || (category = this.categories.get(uid = ICraftingBuildingModule.getUid(jobEntry, moduleView.getId()))) == null) continue;
            return category;
        }
        return null;
    }

    @NotNull
    public <I> List<IGhostIngredientHandler.Target<I>> getTargets(@NotNull W gui, @NotNull I ingredient, boolean doStart) {
        ArrayList<IGhostIngredientHandler.Target<I>> targets = new ArrayList<IGhostIngredientHandler.Target<I>>();
        if (ingredient instanceof ItemStack) {
            for (final Slot slot : gui.func_212873_a_().field_75151_b) {
                if (!slot.func_111238_b() || !this.isSupportedSlot(slot)) continue;
                final Rectangle2d bounds = new Rectangle2d(gui.getGuiLeft() + slot.field_75223_e, gui.getGuiTop() + slot.field_75221_f, 17, 17);
                targets.add(new IGhostIngredientHandler.Target<I>((ContainerScreen)gui){
                    final /* synthetic */ ContainerScreen val$gui;
                    {
                        this.val$gui = containerScreen;
                    }

                    @NotNull
                    public Rectangle2d getArea() {
                        return bounds;
                    }

                    public void accept(@NotNull I ingredient) {
                        slot.func_75215_d((ItemStack)ingredient);
                        AbstractTeachingGuiHandler.this.updateServer(this.val$gui);
                    }
                });
            }
        }
        return targets;
    }

    public void onComplete() {
    }
}

